            )                     !         	                            9     T     a     d     {                                
             
     *  
   2     @     O     S    Z           %   5  -   
   c:  	   q:     {:      :     :     :     :     ;     ;     ;     %;     4;     <;     U;     p;  
   ;     ;  
   ;     ;  !   ;     ;     ;     <     <     <                                                       	            
                    
                                                   <
card <<
trick <body><h1>Deal constraints</h1>
<h2>About</h2>
<p>Deal constraints allow to describe and take into consideration information from previous game parts (for example bidding). Constraints decide if given cards distribution fit to this parts.</p>
<p>Deal constraints are described by body of function in <b>Lua</b> programming language.<br>Four arguments (named <b>N</b>, <b>E</b>, <b>S</b>, <b>W</b>) which describe players hands are available.<br>Function is a filter which can <b>accept</b> or <b>refuse</b> deal described by its arguments and should <b>return</b>:<br>- <b>true</b> or <b>number greater than 0</b> - to <b>accept</b> the deal,<br>- <b>false</b> or <b>0</b> - to <b>refuse</b> it.<br>In case of returning a number, result will be interpreted as conditional probability that if given cards distribution was dealt than player have made actions which we described. Returning <b>true</b> is equal to returning <b>1</b>.</p>
<h2>Examples</h2>
<p>1. accept deals in which E has 12 or more honour points, and more than 2 points in diamonds:<br><code>return E:hcp() &gt;= 12 and E:D():hcp() &gt; 2</code></p>
<p>2. accept deals in which W opens 1 spade and should have 5 or more spades, and 11 or more honour points (but we know that W sometimes opens with 4 spades):<br><code>if W:hcp() &lt; 11 then return false end<br>local s = W:spades()<br>if s &gt;= 5 then return true end<br>if s == 4 then return 0.02 end<br>return false<br></code></p>
</p>
<h2>Cards set operations</h2>
<p>Following operators are defined for cards sets (for sets <code>s1</code>, <code>s2</code>):<br><code>s1<b>+</b>s2</code> - sum of the sets, for example:<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>E:S()+E:H()</code> represents E majors<br><code>s1<b>*</b>s2</code> - product of the sets, for example:<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>W*C.new("A.A..")</code> represents W majors aces<br><code>s1<b>-</b>s2</code> - difference of the sets, for example:<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>N-N:S()</code> represents N cards without spades<br><code><b>-</b>s1</code> - complement of set, for example:<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>-S</code> represents all 52-13 cards not included in S's hand<br><code><b>#</b>s1</code> - number of cards in s1, for example:<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>#N:S()</code> - a number of spades cards in N's hand<br><code>s1<b>^</b>s2</code> - xor, set of cards which are in exactly one set <code>s1</code> or <code>s2</code><br><code>s1<b>==</b>s2</code> - is <code>true</code> only if sets <code>s1</code> and <code>s2</code> are equals<br><code>s1<b>~=</b>s2</code> - is <code>true</code> only if sets <code>s1</code> and <code>s2</code> are not equals<br><code>s1<b>&lt;=</b>s2</code> - is <code>true</code> only if set <code>s1</code> is included in <code>s2</code><br><code>s1<b>&lt;</b>s2</code> - is <code>true</code> only if set <code>s1</code> is included in but not equal to <code>s2</code><br></p>
<h2>Commands</h2>
<p>Note that each command, excluding <code>new</code>, can be call as <code>C.command_name(arg1, arg2, ..., argN)</code> or <code>arg1:command_name(arg2, ..., argN)</code>.</p>
<p>For cards sets <code>c</code>, <code>c1</code>, <code>c2</code>, ..., a function <code>f</code>, a string <code>str</code>:</p>
<p><code>C.<b>new</b>(str)</code> - constructs a set of cards described by the string <code>str</code>, for example <code>C.new("AK87.975.87.QT92")</code>;</p>
<p><code><b>count</b>(c)</code> - a number of cards in the given cards set <code>c</code>, same as <code>#c</code>;</p>
<p><code><b>spades</b>(c)</code>, <code><b>hearts</b>(c)</code>, <code><b>diamonds</b>(c)</code>, <code><b>clubs</b>(c)</code>, <code><b>Scount</b>(c)</code>, <code><b>Hcount</b>(c)</code>, <code><b>Dcount</b>(c)</code>, <code><b>Ccount</b>(c)</code> - a number of cards in the set of cards <code>c</code>, in spades, hearts, diamonds, clubs suit respectively;</p>
<p><code><b>S</b>(c)</code>, <code><b>H</b>(c)</code>, <code><b>D</b>(c)</code>, <code><b>C</b>(c)</code> - cards in spades, hearts, diamonds, clubs suit respectively in the set of cards <code>c</code>;</p>
<p><code><b>hcp</b>(c)</code>, <code><b>miltons</b>(c)</code> - honour points (4 for Ace, 3 for King, 2 for Queen, 1 for Jack) in the given cards set <code>c</code>;</p>
<p><code><b>controls</b>(c)</code> - controls (2 for Ace, 1 for King) in the given cards set <code>c</code>;</p>
<p><code><b>points</b>(c, wAce, wKing, ...)</code> - calculate <code>wAce</code> * Aces + <code>wKing</code> * Kings + ..., where Aces, Kings, ... are the numbers of aces, kings, ... in <code>c</code>;</p>
<p><code><b>balanced</b>(c)</code> - calculate logic value equals to <code>true</code> only if <code>c</code> is balanced;</p>
<p><code><b>semiBalanced</b>(c)</code> - calculate logic value equals to <code>true</code> only if <code>c</code> includes minimum 2 cards in all suits, maximum 5 cards in each major and maximum 6 cards in each minor;</p>
<p><code><b>union</b>(c1, c2, ...)</code> - union of the sets, same as <code>c1+c2+...</code>;</p>
<p><code><b>product</b>(c1, c2, ...)</code> - product of the sets, same as <code>c1*c2*...</code>;</p>
<p><code><b>complement</b>(c)</code> - complement of the cards set <code>c</code>, same as <code>-c</code>;</p>
<p><code><b>xor</b>(c1, c2, ...)</code> - same as <code>c1 ^ c2 ^ ...</code>;</p>
<p><code><b>shape</b>(c)</code> - return 4 numbers: <code>spades(c), hearts(c), diamonds(c), clubs(c)</code> (in the given order);</p>
<p><code><b>shape</b>(c, f)</code> - calculates and returns <code>f(spades(c), hearts(c), diamonds(c), clubs(c))</code>;</p>
<p><code><b>pattern</b>(c)</code> - returns 4 numbers: <code>spades(c), hearts(c), diamonds(c), clubs(c)</code> (in non-increasing order, from highest to lowest);</p>
<p><code><b>pattern</b>(c, f)</code> - returns <code>f(c1, c2, c3, c4)</code>, where <code>c1, c2, c3, c4 = pattern(c)</code>;</p>
<p><code><b>hcp_in_range</b>(c, from, to)</code> - returns <code>true</code> if <code>hcp(c)</code> is in the range [from, to], and <code>false</code> if it's not;</p>
<p><code><b>nt</b>(c, from, to)</code> - calculates logic value equals to <code>true</code> only if <code>c</code> is balanced and <code>hcp(c)</code> is in the range [from, to].</p>
<p>Note that most of commands can be called with more than one argument and than they return more than one result (one per argument). In such case:<br><code>command(a, b, ...)</code><br> is equal to <br><code>command(a), command(b), ...</code><br>For example you can write:<br><code>EpS, EpH = C.hcp(E:S(), E:H())</code><br>to obtain number of E honour points in spades and hearts.</p>
</body> Constraints: Contract: Contract@CF00;*@n;: Declarer cards@CF00;*@n;: Dummy cards@CF00;*@n;: Known left oponent cards: Known right oponent cards: Leader hand: NT Probability estimator: Problem details: Solver: Tricks already taken: Tricks taken, needed/left: Unkown cards left: declarer dummy left defender more calculation (1sec) much more calculation (5sec) non-vul problem setup right defender vul |<
all Project-Id-Version: sdsolvergui
Report-Msgid-Bugs-To: 
POT-Creation-Date: 2013-11-08 12:09+0100
PO-Revision-Date: 2013-11-08 12:13+0100
Last-Translator: Piotr Beling <qwak@w8.pl>
Language-Team: polski <qwak@w8.pl>
Language: pl
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
Plural-Forms: nplurals=3; plural=(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);
X-Generator: Gtranslator 2.91.6
 <
karta <<
lewa <body><h1>Ograniczenia</h1>
<h2>Wstęp</h2>
<p>Ograniczenia umożliwiają wprowadzenie i uwzględnienie informacji wynikających z wcześniejszych faz gry (np. licytacji). Decydują czy konkretny, pełny rozkład pasuje do dotychczasowego przebiegu gry.</p>
<p>Ograniczenia są opisane przez ciało funkcji języka programowania <b>Lua</b>.<br>Dostępne są cztery argumenty (o nazwach <b>N</b>, <b>E</b>, <b>S</b>, <b>W</b>) które opisują poszczególne ręce.<br>Funkcja jest filtrem który może <b>zaakceptować</b> lub <b>odrzucić</b> rozdanie opisane przez podane argumenty i powinna <b>zwrócić</b> (ang. <b>return</b>):<br>- <b>true</b> lub <b>liczbę większą od 0</b> - by <b>zaakceptować</b> rozkład,<br>- <b>false</b> lub <b>0</b> - by go <b>odrzucić</b>.<br>W przypadku gdy zostanie zwrócona liczba, jest ona interpretowana jako prawdopodobieństwo warunkowe tego, że gracze wykonali opisywane akcje pod warunkiem, że dany rozkład został wylosowany. Zwrócenie <b>true</b> jest równoważne ze zwróceniem wartości <b>1</b>.</p>
<h2>Przykłady</h2>
<p>1. akceptuje rozdania w których E ma 12 lub więcej punktów, przy czym co najmniej 2 punkty w karach:<br><code>return E:hcp() &gt;= 12 and E:D():hcp() &gt; 2</code></p>
<p>2. akceptuje rozdania w których W otworzył 1 pik i powinien mieć co najmniej 5 pików i 11 punktów (ale wiemy, że W czasami otwiera też tak mając 4 piki):<br><code>if W:hcp() &lt; 11 then return false<br>local s = W:spades()<br>if s &gt;= 5 then return true<br>if s == 4 then return 0.02<br>return false<br></code></p></p>
<h2>Operacje na zbiorach kart</h2>
<p>Następujące operacje są zdefiniowane dla zbiorów kart (dla zbiorów <code>s1</code>, <code>s2</code>):<br>
<code>s1<b>+</b>s2</code> - suma zbiorów, np.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>E:S()+E:H()</code> to starsze kolory E<br>
<code>s1<b>*</b>s2</code> - iloczyn zbiorów, np.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>W*C.new("A.A..")</code> to asy w starszych kolorach u W<br>
<code>s1<b>-</b>s2</code> - różnica zbiorów, np.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>N-N:S()</code> karty N-a poza pikami<br>
<code><b>-</b>s1</code> - dopełnienie zbioru, np.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>-S</code> to wszystkie 52-13 karty nie S-a<br>
<code><b>#</b>s1</code> - liczba kart w s1, np.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>#N:S()</code> - liczba pików w ręce N<br><code>s1<b>^</b>s2</code> - xor, zbiór kart które są w dokładnie w jednym ze zbiorów <code>s1</code> lub <code>s2</code><br><code>s1<b>==</b>s2</code> - <code>true</code> tylko gdy <code>s1</code> i <code>s2</code> są równe<br>
<code>s1<b>~=</b>s2</code> - <code>true</code> tylko gdy <code>s1</code> i <code>s2</code> są różne<br>
<code>s1<b>&lt;=</b>s2</code> - <code>true</code> tylko gdy zbiór <code>s1</code> jest zawarty w <code>s2</code><br>
<code>s1<b>&lt;</b>s2</code> - <code>true</code> tylko gdy zbiór <code>s1</code> jest zawarty i równocześnie różny od <code>s2</code><br></p>
<h2>Funkcje</h2>
<p>Uwaga: wszystkie funkcje, poza <code>new</code>, mogą być wywołane w następujący sposób: <code>C.nazwa_funkcji(arg1, arg2, ..., argN)</code> lub <code>arg1:nazwa_funkcji(arg2, ..., argN)</code>.</p>
<p>Dla zbiorów kart <code>c</code>, <code>c1</code>, <code>c2</code>, ..., funkcji <code>f</code>, łańcucha <code>str</code>:</p>
<p><code>C.<b>new</b>(str)</code> - konstruuje zbiór kart opisany łańcuchem <code>str</code>, np. <code>C.new("AK87.975.87.QT92")</code>;</p>
<p><code><b>count</b>(c)</code> - liczba kart w zbiorze <code>c</code>, to samo co <code>#c</code>;</p>
<p><code><b>spades</b>(c)</code>, <code><b>hearts</b>(c)</code>, <code><b>diamonds</b>(c)</code>, <code><b>clubs</b>(c)</code>, <code><b>Scount</b>(c)</code>, <code><b>Hcount</b>(c)</code>, <code><b>Dcount</b>(c)</code>, <code><b>Ccount</b>(c)</code> - liczba kart w zbiorze <code>c</code>, w, kolejno: pikach, kierach, karach, treflach;</p>
<p><code><b>S</b>(c)</code>, <code><b>H</b>(c)</code>, <code><b>D</b>(c)</code>, <code><b>C</b>(c)</code> - podzbiór kart <code>c</code>, w, kolejno: pikach, kierach, karach, treflach;</p>
<p><code><b>hcp</b>(c)</code>, <code><b>miltons</b>(c)</code> - punkty honorowe (4 za asa, 3 za króla, 2 za damę, 1 za waleta) w zbiorze <code>c</code>;</p>
<p><code><b>controls</b>(c)</code> - kontrole (2 za asa, 1 za króla) w zbiorze <code>c</code>;</p>
<p><code><b>points</b>(c, wAce, wKing, ...)</code> - oblicza <code>wAce</code> * Aces + <code>wKing</code> * Kings + ..., gdzie Aces, Kings, ... to liczna asów, króli, ... w <code>c</code>;</p>
<p><code><b>balanced</b>(c)</code> - oblicza wartość logiczną równą <code>true</code> tylko gdy <code>c</code> jest zrównoważony;</p>
<p><code><b>semiBalanced</b>(c)</code> - oblicza wartość logiczną równą <code>true</code> tylko gdy <code>c</code> zawiera minimum 2 karty w każdym kolorze, maksimum 5 w każdym kolorze starszym i maksimum 6 każdym kolorze młodszym;</p>
<p><code><b>union</b>(c1, c2, ...)</code> - suma zbiorów, to samo co <code>c1+c2+...</code>;</p>
<p><code><b>product</b>(c1, c2, ...)</code> - iloczyń zbiorów, to samo co <code>c1*c2*...</code>;</p>
<p><code><b>complement</b>(c)</code> - dopełnienie zbioru <code>c</code>, to samo co <code>-c</code>;</p>
<p><code><b>xor</b>(c1, c2, ...)</code> - to samo co <code>c1 ^ c2 ^ ...</code>;</p>
<p><code><b>shape</b>(c)</code> - zwraca 4 liczby: <code>spades(c), hearts(c), diamonds(c), clubs(c)</code> (w podanej kolejności);</p>
<p><code><b>shape</b>(c, f)</code> - oblicza i zwraca <code>f(spades(c), hearts(c), diamonds(c), clubs(c))</code>;</p>
<p><code><b>pattern</b>(c)</code> - zwraca 4 liczby: <code>spades(c), hearts(c), diamonds(c), clubs(c)</code> (w kolejności nie-rosnącej, od największej do najmniejszej);</p>
<p><code><b>shapeDec</b>(c, f)</code> - zwraca <code>f(c1, c2, c3, c4)</code>, gdzie <code>c1, c2, c3, c4 = shapeDec(c)</code>;</p>
<p><code><b>hcp_in_range</b>(c, from, to)</code> - zwraca <code>true</code> tylko gdy <code>hcp(c)</code> mieści się w przedziale [from, to]</p>
<p><code><b>nt</b>(c, from, to)</code> - zwraca <code>true</code> tylko gdy <code>c</code> jest zrównoważona i <code>hcp(c)</code> mieści się w przedziale [from, to].</p>
<p>Uwaga: większość funkcji może przyjąć więcej niż jeden argument i, wtedy, zwrócić więcej wyników (jeden na argument). W takim wypadku:<br><code>funkcja(a, b, ...)</code><br> jest równa <br><code>funkcja(a), funkcja(b), ...</code><br>Na przykład można napisać:<br><code>EpS, EpH = C.hcp(E:S(), E:H())</code><br>by uzyskać liczbę punktów honorowych E w pikach i kierach.</p>
</body> Ograniczenia: Kontrakt: Kontrakt@CF00;*@n;: Karty rozgrywającego@CF00;*@n;: Karty dziadka@CF00;*@n;: Znane karty lewego obrońcy: Znane karty prawego obrońcy: Wistujący: BA Estymator prawd.: Dane problemu: Metoda: Dotychczas wzięte lewy: Lewy wzięte, potrzebne/z: Inne, pozostałe karty: rozgrywający dziadek lewy obrońca więcej obliczeń (1sek) znacznie więcej obliczeń (5sek) przed konfiguracja problemu prawy obrońca po |<
wszystko 